<?php

/**
 * Author: Robert DeVore | @deviorobert
 * URL: html5blank.com | @html5blank
 * Custom functions, support, custom post types and more.
 */

require_once 'modules/is-debug.php';

/*------------------------------------*\
    External Modules/Files
\*------------------------------------*/

// Load any external files you have here

/*------------------------------------*\
    Theme Support
\*------------------------------------*/

if (!isset($content_width)) {
    $content_width = 900;
}

if (function_exists('add_theme_support')) {

    // Add Thumbnail Theme Support.
    add_theme_support('post-thumbnails');
    add_image_size('large', 700, '', true); // Large Thumbnail.
    add_image_size('medium', 250, '', true); // Medium Thumbnail.
    add_image_size('small', 120, '', true); // Small Thumbnail.
    add_image_size('custom-size', 700, 200, true); // Custom Thumbnail Size call using the_post_thumbnail('custom-size');

    // Add Support for Custom Backgrounds - Uncomment below if you're going to use.
    /*add_theme_support('custom-background', array(
    'default-color' => 'FFF',
    'default-image' => get_template_directory_uri() . '/img/bg.jpg'
    ));*/

    // Add Support for Custom Header - Uncomment below if you're going to use.
    /*add_theme_support('custom-header', array(
    'default-image'          => get_template_directory_uri() . '/img/headers/default.jpg',
    'header-text'            => false,
    'default-text-color'     => '000',
    'width'                  => 1000,
    'height'                 => 198,
    'random-default'         => false,
    'wp-head-callback'       => $wphead_cb,
    'admin-head-callback'    => $adminhead_cb,
    'admin-preview-callback' => $adminpreview_cb
    ));*/

    // Enables post and comment RSS feed links to head.
    add_theme_support('automatic-feed-links');

    // Enable HTML5 support.
    add_theme_support('html5', array('comment-list', 'comment-form', 'search-form', 'gallery', 'caption'));

    // Localisation Support.
    load_theme_textdomain('html5blank', get_template_directory() . '/languages');
}

/*------------------------------------*\
    Functions
\*------------------------------------*/

// HTML5 Blank navigation
function html5blank_nav()
{
    wp_nav_menu(
        array(
            'theme_location'  => 'header-menu',
            'menu'            => '',
            'container'       => 'div',
            'container_class' => 'menu-{menu slug}-container',
            'container_id'    => '',
            'menu_class'      => 'menu',
            'menu_id'         => '',
            'echo'            => true,
            'fallback_cb'     => 'wp_page_menu',
            'before'          => '',
            'after'           => '',
            'link_before'     => '',
            'link_after'      => '',
            'items_wrap'      => '<ul>%3$s</ul>',
            'depth'           => 0,
            'walker'          => '',
        )
    );
}

// Load HTML5 Blank scripts (header.php)
function html5blank_header_scripts()
{
    if ($GLOBALS['pagenow'] != 'wp-login.php' && !is_admin()) {
        // Slick
        wp_register_script('slick-js', '//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array('jquery'), '1.0.0');
        wp_enqueue_script('slick-js');

        // Bootstrap
        wp_register_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js', array('jquery'), '1.0.0');
        wp_enqueue_script('bootstrap-js');
        
        wp_register_script('mask', 'https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.js', array('jquery'), '1.0.0');
        wp_enqueue_script('mask');

        // Scripts minify
        wp_register_script('html5blankscripts', get_template_directory_uri() . '/js/scripts.js', array('mask'), '1.0.0');
        // Enqueue Scripts
        wp_enqueue_script('html5blankscripts');

        wp_enqueue_script('ajax', get_template_directory_uri() . '/js/ajax.js', ['jquery'], '1.0', true);

        wp_localize_script('ajax', 'script_ajax', array(
            'api_url' => home_url(),
            'questions' => get_field('questions'),
            'directory_uri' => get_template_directory_uri()
        ));
    }
}

// Load HTML5 Blank conditional scripts
function html5blank_conditional_scripts()
{
    if (is_page('pagenamehere')) {
        wp_register_script('scriptname', get_template_directory_uri() . '/js/scriptname.js', array('jquery'), '1.0.0');
        wp_enqueue_script('scriptname');
    }
}

// Load HTML5 Blank styles
function html5blank_styles()
{
    // FontAwesome
    wp_register_style('fontawesome-css', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css', array(), '1.0');
    wp_enqueue_style('fontawesome-css');

    // Slick Carousel
    wp_register_style('slick-css', '//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css', array(), '1.0');
    wp_enqueue_style('slick-css');

    // Bootstrap
    wp_register_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css', array(), '1.0');
    wp_enqueue_style('bootstrap-css');

    // Custom CSS
    wp_register_style('html5blankcssmin', get_template_directory_uri() . '/css/style.css', array(), '1.0');
    // Register CSS
    wp_enqueue_style('html5blankcssmin');

    //Coditional
    if (is_page('home')) {
        wp_register_style('home', get_template_directory_uri() . '/css/pages/home.css', array(), '1.0');
        wp_enqueue_style('home');
    }
    if (is_page('para-voce')) {
        wp_register_style('para-voce', get_template_directory_uri() . '/css/pages/para-voce.css', array(), '1.0');
        wp_enqueue_style('para-voce');
    }
    if (is_archive('para-seu-negocio')) {
        wp_register_style('para-seu-negocio', get_template_directory_uri() . '/css/pages/para-seu-negocio.css', array(), '1.0');
        wp_enqueue_style('para-seu-negocio');
    }
    if (is_singular('para-seu-negocio')) {
        wp_register_style('para-seu-negocio-det', get_template_directory_uri() . '/css/pages/para-seu-negocio-det.css', array(), '1.0');
        wp_enqueue_style('para-seu-negocio-det');
    }
    if (is_page('vantagens')) {
        wp_register_style('vantagens', get_template_directory_uri() . '/css/pages/vantagens.css', array(), '1.0');
        wp_enqueue_style('vantagens');
    }
    if (is_page('vantagens-app')) {
        wp_register_style('vantagens-app', get_template_directory_uri() . '/css/pages/vantagens-app.css', array(), '1.0');
        wp_enqueue_style('vantagens-app');
    }
    if (is_page('quem-somos')) {
        wp_register_style('quem-somos', get_template_directory_uri() . '/css/pages/quem-somos.css', array(), '1.0');
        wp_enqueue_style('quem-somos');
    }
    if (is_page('ajuda')) {
        wp_register_style('faq', get_template_directory_uri() . '/css/pages/faq.css', array(), '1.0');
        wp_enqueue_style('faq');
    }
    if (is_page('blog') || is_search() || is_category() || is_tag()) {
        wp_register_style('blog', get_template_directory_uri() . '/css/pages/blog.css', array(), '1.0');
        wp_enqueue_style('blog');
    }
    if (is_page('politica-de-privacidade')) {
        wp_register_style('politica-de-privacidade', get_template_directory_uri() . '/css/pages/politica-de-privacidade.css', array(), '1.0');
        wp_enqueue_style('politica-de-privacidade');
    }
    if (is_page('termos-de-uso')) {
        wp_register_style('termos-de-uso', get_template_directory_uri() . '/css/pages/termos-de-uso.css', array(), '1.0');
        wp_enqueue_style('termos-de-uso');
    }
    if (is_singular('post')) {
        wp_register_style('post', get_template_directory_uri() . '/css/pages/post.css', array(), '1.0');
        wp_enqueue_style('post');
    }
    if (is_404()) {
        wp_register_style('404', get_template_directory_uri() . '/css/pages/404.css', array(), '1.0');
        wp_enqueue_style('404');
    }
}

// Register HTML5 Blank Navigation
function register_html5_menu()
{
    register_nav_menus(array( // Using array to specify more menus if needed
        'header-menu'  => esc_html('Header Menu', 'html5blank'), // Main Navigation
        'extra-menu'   => esc_html('Extra Menu', 'html5blank') // Extra Navigation if needed (duplicate as many as you need!)
    ));
}

// Remove the <div> surrounding the dynamic navigation to cleanup markup
function my_wp_nav_menu_args($args = '')
{
    $args['container'] = false;
    return $args;
}

// Remove Injected classes, ID's and Page ID's from Navigation <li> items
function my_css_attributes_filter($var)
{
    return is_array($var) ? array() : '';
}

// Remove invalid rel attribute values in the categorylist
function remove_category_rel_from_category_list($thelist)
{
    return str_replace('rel="category tag"', 'rel="tag"', $thelist);
}

// Add page slug to body class, love this - Credit: Starkers Wordpress Theme
function add_slug_to_body_class($classes)
{
    global $post;
    if (is_home()) {
        $key = array_search('blog', $classes, true);
        if ($key > -1) {
            unset($classes[$key]);
        }
    } elseif (is_page()) {
        $classes[] = sanitize_html_class($post->post_name);
    } elseif (is_singular()) {
        $classes[] = sanitize_html_class($post->post_name);
    }

    return $classes;
}

// Remove the width and height attributes from inserted images
function remove_width_attribute($html)
{
    $html = preg_replace('/(width|height)="\d*"\s/', "", $html);
    return $html;
}


// If Dynamic Sidebar Exists
if (function_exists('register_sidebar')) {
    // Define Sidebar Widget Area 1
    register_sidebar(array(
        'name'          => esc_html('Widget Area 1', 'html5blank'),
        'description'   => esc_html('Description for this widget-area...', 'html5blank'),
        'id'            => 'widget-area-1',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));

    // Define Sidebar Widget Area 2
    register_sidebar(array(
        'name'          => esc_html('Widget Area 2', 'html5blank'),
        'description'   => esc_html('Description for this widget-area...', 'html5blank'),
        'id'            => 'widget-area-2',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));
}

// Remove wp_head() injected Recent Comment styles
function my_remove_recent_comments_style()
{
    global $wp_widget_factory;

    if (isset($wp_widget_factory->widgets['WP_Widget_Recent_Comments'])) {
        remove_action('wp_head', array(
            $wp_widget_factory->widgets['WP_Widget_Recent_Comments'],
            'recent_comments_style'
        ));
    }
}

// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function html5wp_pagination()
{
    global $wp_query;
    $big = 999999999;
    echo paginate_links(array(
        'base'    => str_replace($big, '%#%', get_pagenum_link($big)),
        'format'  => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total'   => $wp_query->max_num_pages,
    ));
}

// Create 20 Word Callback for Index page Excerpts, call using html5wp_excerpt('html5wp_index');
function html5wp_index($length)
{
    return 20;
}

// Create 40 Word Callback for Custom Post Excerpts, call using html5wp_excerpt('html5wp_custom_post');
function html5wp_custom_post($length)
{
    return 14;
}

// Create the Custom Excerpts callback
function html5wp_excerpt($length_callback = '', $more_callback = '')
{
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo esc_html($output);
}

// Remove Admin bar
function remove_admin_bar()
{
    return false;
}

// Remove 'text/css' from our enqueued stylesheet
function html5_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}

// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions($html)
{
    $html = preg_replace('/(width|height)=\"\d*\"\s/', '', $html);
    return $html;
}

// Custom Gravatar in Settings > Discussion
function html5blankgravatar($avatar_defaults)
{
    $myavatar                   = get_template_directory_uri() . '/img/gravatar.jpg';
    $avatar_defaults[$myavatar] = 'Custom Gravatar';
    return $avatar_defaults;
}

// Threaded Comments
function enable_threaded_comments()
{
    if (!is_admin()) {
        if (is_singular() and comments_open() and (get_option('thread_comments') == 1)) {
            wp_enqueue_script('comment-reply');
        }
    }
}

// Custom Comments Callback
function html5blankcomments($comment, $args, $depth)
{
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);

    if ('div' == $args['style']) {
        $tag       = 'div';
        $add_below = 'comment';
    } else {
        $tag       = 'li';
        $add_below = 'div-comment';
    }
?>
    <!-- heads up: starting < for the html tag (li or div) in the next line: -->
    <<?php echo esc_html($tag) ?> <?php comment_class(empty($args['has_children']) ? '' : 'parent') ?> id="comment-<?php comment_ID(); ?>">
        <?php if ('div' != $args['style']) : ?>
            <div id="div-comment-<?php comment_ID(); ?>" class="comment-body">
            <?php endif; ?>
            <div class="comment-author vcard">
                <?php if ($args['avatar_size'] != 0) echo get_avatar($comment, $args['avatar_size']); ?>
                <?php printf(esc_html('<cite class="fn">%s</cite> <span class="says">says:</span>'), get_comment_author_link()) ?>
            </div>
            <?php if ($comment->comment_approved == '0') : ?>
                <em class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.') ?></em>
                <br />
            <?php endif; ?>

            <div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars(get_comment_link($comment->comment_ID)) ?>">
                    <?php
                    printf(esc_html('%1$s at %2$s'), get_comment_date(), get_comment_time()) ?></a><?php edit_comment_link(esc_html_e('(Edit)'), '  ', '');
                                                                                                    ?>
            </div>

            <?php comment_text() ?>

            <div class="reply">
                <?php comment_reply_link(array_merge($args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </div>
            <?php if ('div' != $args['style']) : ?>
            </div>
        <?php endif; ?>
    <?php }

/*------------------------------------*\
    Actions + Filters + ShortCodes
\*------------------------------------*/

// Add Actions
add_action('wp_enqueue_scripts', 'html5blank_header_scripts'); // Add Custom Scripts to wp_head
add_action('wp_print_scripts', 'html5blank_conditional_scripts'); // Add Conditional Page Scripts
add_action('get_header', 'enable_threaded_comments'); // Enable Threaded Comments
add_action('wp_enqueue_scripts', 'html5blank_styles'); // Add Theme Stylesheet
add_action('init', 'register_html5_menu'); // Add HTML5 Blank Menu
add_action('init', 'create_post_type_html5'); // Add our HTML5 Blank Custom Post Type
add_action('widgets_init', 'my_remove_recent_comments_style'); // Remove inline Recent Comment Styles from wp_head()
add_action('init', 'html5wp_pagination'); // Add our HTML5 Pagination

// Remove Actions
remove_action('wp_head', 'feed_links_extra', 3); // Display the links to the extra feeds such as category feeds
remove_action('wp_head', 'feed_links', 2); // Display the links to the general feeds: Post and Comment Feed
remove_action('wp_head', 'rsd_link'); // Display the link to the Really Simple Discovery service endpoint, EditURI link
remove_action('wp_head', 'wlwmanifest_link'); // Display the link to the Windows Live Writer manifest file.
remove_action('wp_head', 'wp_generator'); // Display the XHTML generator that is generated on the wp_head hook, WP version
remove_action('wp_head', 'rel_canonical');
remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);

// Add Filters
add_filter('avatar_defaults', 'html5blankgravatar'); // Custom Gravatar in Settings > Discussion
add_filter('body_class', 'add_slug_to_body_class'); // Add slug to body class (Starkers build)
add_filter('widget_text', 'do_shortcode'); // Allow shortcodes in Dynamic Sidebar
add_filter('widget_text', 'shortcode_unautop'); // Remove <p> tags in Dynamic Sidebars (better!)
add_filter('wp_nav_menu_args', 'my_wp_nav_menu_args'); // Remove surrounding <div> from WP Navigation
// add_filter( 'nav_menu_css_class', 'my_css_attributes_filter', 100, 1 ); // Remove Navigation <li> injected classes (Commented out by default)
// add_filter( 'nav_menu_item_id', 'my_css_attributes_filter', 100, 1 ); // Remove Navigation <li> injected ID (Commented out by default)
// add_filter( 'page_css_class', 'my_css_attributes_filter', 100, 1 ); // Remove Navigation <li> Page ID's (Commented out by default)
add_filter('the_category', 'remove_category_rel_from_category_list'); // Remove invalid rel attribute
add_filter('the_excerpt', 'shortcode_unautop'); // Remove auto <p> tags in Excerpt (Manual Excerpts only)
add_filter('the_excerpt', 'do_shortcode'); // Allows Shortcodes to be executed in Excerpt (Manual Excerpts only)
add_filter('show_admin_bar', 'remove_admin_bar'); // Remove Admin bar
add_filter('style_loader_tag', 'html5_style_remove'); // Remove 'text/css' from enqueued stylesheet
add_filter('post_thumbnail_html', 'remove_thumbnail_dimensions', 10); // Remove width and height dynamic attributes to thumbnails
add_filter('post_thumbnail_html', 'remove_width_attribute', 10); // Remove width and height dynamic attributes to post images
add_filter('image_send_to_editor', 'remove_width_attribute', 10); // Remove width and height dynamic attributes to post images

// Remove Filters
remove_filter('the_excerpt', 'wpautop'); // Remove <p> tags from Excerpt altogether

// Shortcodes
add_shortcode('html5_shortcode_demo', 'html5_shortcode_demo'); // You can place [html5_shortcode_demo] in Pages, Posts now.
add_shortcode('html5_shortcode_demo_2', 'html5_shortcode_demo_2'); // Place [html5_shortcode_demo_2] in Pages, Posts now.

// Shortcodes above would be nested like this -
// [html5_shortcode_demo] [html5_shortcode_demo_2] Here's the page title! [/html5_shortcode_demo_2] [/html5_shortcode_demo]

/*------------------------------------*\
    Custom Post Types
\*------------------------------------*/

// Create 1 Custom Post type for a Demo, called HTML5-Blank
function create_post_type_html5()
{
    register_taxonomy_for_object_type('category', 'html5-blank'); // Register Taxonomies for Category
    register_taxonomy_for_object_type('post_tag', 'html5-blank');
    register_post_type(
        'para-seu-negocio', // Register Custom Post Type
        array(
            'labels'       => array(
                'name'               => 'Post Para seu Negócio', // Rename these to suit
                'singular_name'      => 'Post Para seu Negócio',
                'add_new'            => 'Adicionar Novo',
                'add_new_item'       => 'Adicionar Novo Post Para seu Negócio',
                'edit'               => 'Editar',
                'edit_item'          => 'Editar Post Para seu Negócio',
                'new_item'           => 'Novo Post Para seu Negócio',
                'view'               => 'Ver Post Para seu Negócio',
                'view_item'          => 'Ver Post Para seu Negócio',
                'search_items'       => 'Pesquisar Post Para seu Negócio',
                'not_found'          => 'Não Encontrado Posts Para seus Negócios',
                'not_found_in_trash' => 'Não Encontrado na Lixeira Posts Para seus Negócios',
            ),
            'public'       => true,
            'hierarchical' => true, // Allows your posts to behave like Hierarchy Pages
            'has_archive'  => true,
            'supports'     => array(
                'title',
                'editor',
                'excerpt',
                'thumbnail'
            ), // Go to Dashboard Custom HTML5 Blank post for supports
            'can_export'   => true, // Allows export in Tools > Export
            'taxonomies'   => array(
                'post_tag',
                'category'
            ) // Add Category and Post Tags support
        )
    );
}

/*------------------------------------*\
    ShortCode Functions
\*------------------------------------*/

// Shortcode Demo with Nested Capability
function html5_shortcode_demo($atts, $content = null)
{
    return '<div class="shortcode-demo">' . do_shortcode($content) . '</div>'; // do_shortcode allows for nested Shortcodes
}

// Demo Heading H2 shortcode, allows for nesting within above element. Fully expandable.
function html5_shortcode_demo_2($atts, $content = null)
{
    return '<h2>' . $content . '</h2>';
}

// Custom shotcode contact form 7
add_filter('shortcode_atts_wpcf7', 'custom_shortcode_atts_wpcf7_filter', 10, 3);

function custom_shortcode_atts_wpcf7_filter($out, $pairs, $atts)
{
    $my_attr = 'product-origin';

    if (isset($atts[$my_attr])) {
        $out[$my_attr] = $atts[$my_attr];
    }

    return $out;
}

function yoastVariableToTitle( $post_id ) {
    $yoast_title = get_post_meta( $post_id, '_yoast_wpseo_title', true );
    $title       = strstr( $yoast_title, '%%', true );
    if ( empty( $title ) ) {
        $title = get_the_title( $post_id );
    }
    $wpseo_titles = get_option( 'wpseo_titles' );

    $sep_options = WPSEO_Option_Titles::get_instance()->get_separator_options();
    if ( isset( $wpseo_titles['separator'] ) && isset( $sep_options[ $wpseo_titles['separator'] ] ) ) {
        $sep = $sep_options[ $wpseo_titles['separator'] ];
    } else {
        $sep = '-'; //setting default separator if Admin didn't set it from backed
    }

    $site_title = get_bloginfo( 'name' );

    $meta_title = $title . ' ' . $sep . ' ' . $site_title;

    return $meta_title;
}

require_once 'includes/Cache.php';

// Pega cursos da streaming da Dflix pela API da FPASS
function get_streaming_courses()
{
    $cache = new Cache();

    $array_courses = $cache->read('streaming-courses');

    if(!$array_courses) {
        $token = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJwZXJtaXNzaW9uIjoibWFjaGluZSIsIndoaXRlbGFiZWwiOiJkZmxpeCIsImlzcyI6InN0cmVhbWluZy5kZmxpeC5jb20uYnIiLCJhdWQiOiJ3d3cuZGZsaXguY29tLmJyIiwiaWF0IjoxNjYyMTQ1ODY3LCJleHAiOjE3MzU2ODk1OTksInN1YiI6ImVhZGUyZjhjLWVjMzItNGY4Ni1hMzYzLThhOTdiZWFjMDBjNiJ9.UVvBhb9h-xXFgDjqhyTJ704Vy2_oprQH5H6k7ylRKG4';
    
        // Requisição para pegar todas as playlists
        $curl = curl_init('https://content-api.fpass.com.br/v2/display/sections?include=default');
    
        curl_setopt_array($curl, [
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
    
                "Accept: application/json",
                "Authorization: Bearer $token",
            ],
            CURLOPT_RETURNTRANSFER => 1,
        ]);
    
        $response = json_decode(curl_exec($curl), true);
        curl_close($curl);
    
        $resourseId = '';
        $array_courses = [];

        foreach ($response as $key => $playlist) {
            sleep(2);
            $resourseId = $playlist['resourceId'];

            // Requisição para pegar cursos de uma playlist específica
            $curl = curl_init("https://content-api.fpass.com.br/v2/display/sections/$resourseId/resources");
    
            curl_setopt_array($curl, [
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => [
    
                    "Accept: application/json",
                    "Authorization: Bearer $token",
                ],
                CURLOPT_RETURNTRANSFER => 1,
            ]);
    
            $response = json_decode(curl_exec($curl), true);

            if(!empty($response)) {
                $array_courses[] = $response;
            }

            curl_close($curl);
        }

        $cache->save('streaming-courses', $array_courses, '24 hours');
    }

    $random_key = array_rand($array_courses, 1);
    $random_key = $random_key == 0 ? 1 : $random_key;
    $array_courses = $array_courses[$random_key];
    #$array_courses = shuffle($array_courses);
    $array_courses = array_slice($array_courses, 0, 6);

    return $array_courses;
}
