(function (root, $, undefined) {
  "use strict";

  $(function () {

    $("input[type=tel]")
      .mask("(99) 99999-9999")
      .focusout(function (event) {
        var target, phone, element;
        target = event.currentTarget ? event.currentTarget : event.srcElement;
        phone = target.value.replace(/\D/g, "");
        element = $(target);
        element.unmask();
        if (phone.length > 10) {
          element.mask("(99) 99999-9999");
        } else {
          element.mask("(99) 9999-9999");
        }
      });

    $("header .btn-open, header .menu-mobile .close-menu").click(function () {
      $("header .menu-mobile").toggleClass("active");
    });

    $("header .menu-mobile .menu li.menu-item-has-children > a i").click(function (event) {
      event.preventDefault();
      $(this).toggleClass("fa-chevron-down");
      $(this).toggleClass("fa-chevron-up");
      $(this).parent().parent().find(".sub-menu").toggleClass("active");
    });

    $("#about .carousel-about").slick({
      slidesToShow: 3,
      arrows: false,
      centerMode: true,
      variableWidth: true,
      autoplay: true,
      autoplaySpeed: 6000,
	    focusOnSelect: true,
      initialSlide: 1
    });

    $("#teachers .carousel").slick({
      infinite: true,
      prevArrow:
        '<button type="button" class="slick-prev"><i class="fa-solid fa-arrow-left-long"></i></button>',
      nextArrow:
        '<button type="button" class="slick-next"><i class="fa-solid fa-arrow-right-long"></i></button>',
    });
    $("#teachers .carousel .content .slick-arrows").append(
      $("#teachers .carousel .slick-arrow")
    );

    $("#forYou").slick({
      infinite: true,
      prevArrow:
        '<button type="button" class="slick-prev"><i class="fa-solid fa-arrow-left-long"></i></button>',
      nextArrow:
        '<button type="button" class="slick-next"><i class="fa-solid fa-arrow-right-long"></i></button>',
      fade: true,
      adaptiveHeight: true
    });
    $("#forYou .container").append($("#forYou .slick-arrow"));

    $("#advantage .carousel").slick({
      responsive: [
        {
          breakpoint: 768,
          settings: {
            infinite: true,
            arrows: false,
            dots: true,
          },
        },
        {
          breakpoint: 9999,
          settings: "unslick",
        },
      ],
    })

    $('#slider-courses').slick({
      arrows: true,
      centerMode: true,
      centerPadding: '60px',
      slidesToShow: 1,
      infinite: true,
      prevArrow:
        '<button type="button" class="slick-prev"><i class="fa-solid fa-arrow-left-long"></i></button>',
      nextArrow:
        '<button type="button" class="slick-next"><i class="fa-solid fa-arrow-right-long"></i></button>',
      responsive: [
        {
          breakpoint: 480,
          settings: {
              arrows: true,
              centerMode: true,
              centerPadding: '60px',
              slidesToShow: 1,
          }
        },
        {
          breakpoint: 768,
          settings: {
              arrows: true,
              centerMode: true,
              centerPadding: '60px',
              slidesToShow: 2,
          }
        },
        {
          breakpoint: 992,
          settings: {
              arrows: true,
              centerMode: true,
              centerPadding: '60px',
              slidesToShow: 6,
          }
        },
        {
          breakpoint: 9999,
          settings: {
            slidesToShow: 6,
          }
        },
      ]
    });
  });
})(this, jQuery);
