<?php get_header(); ?>

<section id="bannerFAQ" class="banner-container" style="background-image: url(<?= get_the_post_thumbnail_url() ?>);">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="bread-crumb">
                    <a href="<?= home_url() ?>">Home</a>
                    >
                    <a href="#">FAQ</a>
                    >
                    <span><?= get_the_title() ?></span>
                </div>
            </div>
            <div class="col-12 col-md-9 mx-auto content">
                <h1>FAQ</h1>
                <div class="search-input">
                    <input type="search" class="form-control" placeholder="Busca">
                </div>
            </div>
        </div>
    </div>
</section>

<section id="faq">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-4 title">
                <p>Tudo o que você precisa saber para entrar para o mundo da Educação Financeira.</p>
                <a href="<?= home_url() ?>/ajuda" class="btn-orange d-md-flex d-none">Saiba mais</a>
            </div>
            <div class="col-12 faqs">
                <?php if (!empty(get_field('questions'))) :
                    $iQuest = 0;
                    while (have_rows('questions')) : the_row() ?>
                        <div class="item-faq">
                            <button type="button" data-bs-toggle="collapse" data-bs-target="#collapseFaq<?= $iQuest ?>" aria-expanded="false" aria-controls="collapseFaq<?= $iQuest ?>"><?= get_sub_field('quest') ?> <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.5 2.5V7.5H2.5V8.5H7.5V13.5H8.5V8.5H13.5V7.5H8.5V2.5H7.5Z" fill="#212121" />
                                </svg></button>
                            <div class="content collapse" id="collapseFaq<?= $iQuest ?>" data-bs-parent="#faq">
                                <p><?= get_sub_field('answer') ?></p>
                            </div>
                        </div>
                <?php $iQuest++;
                    endwhile;
                endif; ?>
                <a href="<?= home_url() ?>/ajuda" class="btn-orange d-flex d-md-none">Saiba mais</a>
            </div>
        </div>
    </div>
</section>

<section id="signFooter">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-4 img">
                <img src="<?= get_template_directory_uri() ?>/img/flat-ipad.png" alt="">
            </div>
            <div class="col-12 col-md-8 content">
                <div class="d-block d-lg-flex">
                    <h2>Assine Anual<br>
                        <span>R$ 99,<span class="cents">80</span></span>
                    </h2>
                    <h2>Assine Mensal<br>
                        <span>R$ 9,<span class="cents">90</span></span>
                    </h2>
                </div>
                <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-black">Assine agora</a>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>