<?php
$pageHome = get_page_by_path('home');
get_header(); ?>

<section id="bannerAdvantage" class="banner-container" style="background-image: url(<?= get_the_post_thumbnail_url() ?>);">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="bread-crumb">
                    <a href="<?= home_url() ?>">Home</a>
                    >
                    <a href="#">Vantagens</a>
                    >
                    <span><?= get_the_title() ?></span>
                </div>
            </div>
            <div class="col-12 col-lg-9 content">
                <h1><?= get_field('title_banner') ?></h1>
                <div class="box-plans">
                    <div>
                        <h2><span>Assinatura Anual</span> <br> R$ 99,80</h2>
                    </div>
                    <div>
                        <h2><span>Assinatura Mensal</span> <br> R$ 9,90</h2>
                    </div>
                </div>
                <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-orange">Assine agora</a>
            </div>
        </div>
    </div>
</section>

<section id="howWork" class="container">
    <div class="row">
        <div class="col-12 title">
            <h2><?= get_field('title_step') ?></h2>
            <p><?= get_field('desc_step') ?></p>
        </div>
    </div>
    <div class="row d-md-none d-flex">
        <?php if (have_rows('steps')) : $countMob = 1;
            while (have_rows('steps')) : the_row();
        ?>
                <div class="col-3 number">
                    <span><?= $countMob ?></span>
                </div>
                <div class="col-9 content">
                    <h2><?= get_sub_field('desc') ?></h2>
                    <img src="<?= get_sub_field('img') ?>" alt="">
                </div>
        <?php $countMob++;
            endwhile;
        endif; ?>
    </div>
    <div class="row d-none d-md-flex">
        <?php if (have_rows('steps')) : $countDesk = 1;
            for ($i = 0; $i < count(get_field('steps')); $i++) :
                if (($i % 2) == 0) :
        ?>
                    <div class="col-5 content text--right justify-content-end">
                        <h2><?= get_field('steps')[$i]['desc'] ?></h2>
                    </div>
                    <div class="col-2 number">
                        <span><?= $countDesk ?></span>
                    </div>
                    <div class="col-5 content">
                        <img src="<?= get_field('steps')[$i]['img'] ?>" alt="">
                    </div>
                <?php $countDesk++;
                else : ?>
                    <div class="col-5 content text--right justify-content-end">
                        <img src="<?= get_field('steps')[$i]['img'] ?>" alt="">
                    </div>
                    <div class="col-2 number">
                        <span><?= $countDesk ?></span>
                    </div>
                    <div class="col-5 content">
                        <h2><?= get_field('steps')[$i]['desc'] ?></h2>
                    </div>
        <?php $countDesk++;
                endif;
            endfor;
        endif; ?>
    </div>
</section>

<section id="advantage">
    <div class="container">
        <div class="row">
            <div class="col-12 title">
                <h2>Vantagens</h2>
                <p>Uma série de vantagens que vão te ajudar quando o assunto é aprender tudo sobre Educação Financeira.</p>
            </div>
            <div class="col-12">
                <div class="row carousel">
                    <div class="col">
                        <div class="item">
                            <svg width="80" height="65" viewBox="0 0 80 65" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M7.16802 0.68001C3.64753 0.68001 0.78418 3.54336 0.78418 7.06385V58.1358C0.78418 61.6563 3.64753 64.5197 7.16802 64.5197H72.832C76.3525 64.5197 79.2159 61.6563 79.2159 58.1358V7.06385C79.2159 3.54336 76.3525 0.68001 72.832 0.68001H12.64C12.3957 0.676829 12.1604 0.770979 11.9867 0.942747C11.813 1.11388 11.715 1.34798 11.715 1.59227C11.715 1.83592 11.813 2.07003 11.9867 2.24179C12.1604 2.41292 12.3957 2.50771 12.64 2.5039H72.832C75.3734 2.5039 77.392 4.52186 77.392 7.0639V58.1359C77.392 60.6779 75.3734 62.6959 72.832 62.6959H7.16802C4.62663 62.6959 2.60802 60.6779 2.60802 58.1359V7.0639C2.60802 4.52186 4.62663 2.5039 7.16802 2.5039C7.4123 2.50771 7.64768 2.41292 7.82135 2.24179C7.99566 2.07003 8.093 1.83592 8.093 1.59227C8.093 1.34798 7.99566 1.11388 7.82135 0.942747C7.64768 0.770981 7.4123 0.676834 7.16802 0.68001ZM15.3763 7.97617C11.8609 7.97617 8.99251 10.8452 8.99251 14.36C8.99251 17.8748 11.8609 20.7438 15.3763 20.7438C18.8911 20.7438 21.7602 17.8748 21.7602 14.36C21.7602 10.8452 18.8911 7.97617 15.3763 7.97617ZM26.149 7.97617C25.6452 8.02325 25.2756 8.46982 25.3226 8.97367C25.3697 9.47752 25.8163 9.84712 26.3201 9.80004H64.6241C67.1662 9.80004 69.1841 11.818 69.1841 14.36C69.1841 16.9021 67.1662 18.92 64.6241 18.92H26.3201C26.0759 18.9169 25.8405 19.011 25.6668 19.1828C25.4931 19.3539 25.3952 19.588 25.3952 19.8323C25.3952 20.076 25.4931 20.3101 25.6668 20.4818C25.8405 20.653 26.0759 20.7477 26.3201 20.7439H64.6241C68.1453 20.7439 71.008 17.8812 71.008 14.3601C71.008 10.839 68.1453 7.97625 64.6241 7.97625H26.3201C26.2635 7.97053 26.2063 7.97053 26.149 7.97625V7.97617ZM15.3763 9.80001C17.9057 9.80001 19.9363 11.8307 19.9363 14.36C19.9363 16.8893 17.9057 18.92 15.3763 18.92C12.847 18.92 10.8163 16.8893 10.8163 14.36C10.8163 11.8307 12.847 9.80001 15.3763 9.80001ZM15.3763 26.216C11.8552 26.216 8.99251 29.0787 8.99251 32.5998C8.99251 36.121 11.8552 38.9837 15.3763 38.9837H53.6803C53.9246 38.9875 54.16 38.8927 54.3337 38.7216C54.5073 38.5498 54.6053 38.3157 54.6053 38.0721C54.6053 37.8278 54.5074 37.5937 54.3337 37.4225C54.16 37.2508 53.9246 37.1566 53.6803 37.1598H15.3763C12.8343 37.1598 10.8163 35.1418 10.8163 32.5998C10.8163 30.0578 12.8343 28.0398 15.3763 28.0398H53.6803C53.9246 28.043 54.16 27.9488 54.3337 27.7771C54.5073 27.6059 54.6053 27.3718 54.6053 27.1275C54.6053 26.8839 54.5074 26.6498 54.3337 26.478C54.16 26.3069 53.9246 26.2121 53.6803 26.2159L15.3763 26.216ZM64.6243 26.216C61.1096 26.216 58.2405 29.0851 58.2405 32.5998C58.2405 36.1146 61.1096 38.9837 64.6243 38.9837C68.1398 38.9837 71.0082 36.1146 71.0082 32.5998C71.0082 29.0851 68.1398 26.216 64.6243 26.216ZM64.6243 28.0398C67.1537 28.0398 69.1843 30.0705 69.1843 32.5998C69.1843 35.1292 67.1537 37.1598 64.6243 37.1598C62.095 37.1598 60.0643 35.1292 60.0643 32.5998C60.0643 30.0705 62.095 28.0398 64.6243 28.0398ZM15.3763 44.4558C11.8609 44.4558 8.99251 47.3249 8.99251 50.8397C8.99251 54.3545 11.8609 57.2235 15.3763 57.2235C18.8911 57.2235 21.7602 54.3545 21.7602 50.8397C21.7602 47.3249 18.8911 44.4558 15.3763 44.4558ZM26.149 44.4558C25.6452 44.5029 25.2756 44.9495 25.3226 45.4533C25.3697 45.9572 25.8163 46.3268 26.3201 46.2797H64.6241C67.1662 46.2797 69.1841 48.2977 69.1841 50.8397C69.1841 53.3818 67.1662 55.3997 64.6241 55.3997H26.3201C26.0759 55.3965 25.8405 55.4907 25.6668 55.6625C25.4931 55.8336 25.3952 56.0677 25.3952 56.312C25.3952 56.5556 25.4931 56.7897 25.6668 56.9615C25.8405 57.1326 26.0759 57.2274 26.3201 57.2236H64.6241C68.1453 57.2236 71.008 54.3609 71.008 50.8398C71.008 47.3186 68.1453 44.4559 64.6241 44.4559H26.3201C26.2635 44.4502 26.2063 44.4502 26.149 44.4559V44.4558ZM15.3763 46.2797C17.9057 46.2797 19.9363 48.3103 19.9363 50.8397C19.9363 53.369 17.9057 55.3997 15.3763 55.3997C12.847 55.3997 10.8163 53.369 10.8163 50.8397C10.8163 48.3103 12.847 46.2797 15.3763 46.2797Z" fill="#EC6608" />
                            </svg>
                            <h3>Plataforma inteligente</h3>
                        </div>
                    </div>
                    <div class="col">
                        <div class="item">
                            <svg width="69" height="68" viewBox="0 0 69 68" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.7838 27.68H3.75434C2.06493 27.68 0.694336 26.3094 0.694336 24.62V3.59052C0.694336 1.90111 2.06495 0.530518 3.75434 0.530518H24.7838C26.4732 0.530518 27.8438 1.90114 27.8438 3.59052V24.62C27.8438 26.3094 26.4732 27.68 24.7838 27.68ZM3.75434 2.92169C3.38778 2.92169 3.08495 3.2245 3.08495 3.59107V24.6206C3.08495 24.9871 3.38776 25.2899 3.75434 25.2899H24.7838C25.1504 25.2899 25.4532 24.9871 25.4532 24.6206V3.59107C25.4532 3.22451 25.1504 2.92169 24.7838 2.92169H3.75434Z" fill="#EC6608" />
                                <path d="M24.7838 67.0695H3.75434C2.06493 67.0695 0.694336 65.6988 0.694336 64.0095V42.98C0.694336 41.2906 2.06495 39.92 3.75434 39.92H24.7838C26.4732 39.92 27.8438 41.2906 27.8438 42.98V64.0095C27.8438 65.6989 26.4732 67.0695 24.7838 67.0695ZM3.75434 42.3112C3.38778 42.3112 3.08495 42.614 3.08495 42.9805V64.01C3.08495 64.3766 3.38776 64.6794 3.75434 64.6794H24.7838C25.1504 64.6794 25.4532 64.3766 25.4532 64.01V42.9805C25.4532 42.614 25.1504 42.3112 24.7838 42.3112H3.75434Z" fill="#EC6608" />
                                <path d="M33.916 5.80591H68.1093V8.19649H33.916V5.80591Z" fill="#EC6608" />
                                <path d="M33.916 20.0139H56.0209V22.4045H33.916V20.0139Z" fill="#EC6608" />
                                <path d="M33.916 45.1948H68.1093V47.5854H33.916V45.1948Z" fill="#EC6608" />
                                <path d="M33.916 59.4036H56.0209V61.7942H33.916V59.4036Z" fill="#EC6608" />
                            </svg>
                            <h3>Conteúdo<br> de qualidade</h3>
                        </div>
                    </div>
                    <div class="col">
                        <div class="item">
                            <svg width="58" height="84" viewBox="0 0 58 84" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M57.1491 0.664893L57.3614 0.452051H56.9999H10.4618H10.3997L10.3558 0.495985L0.892957 9.9588L0.849023 10.0027V10.0649V82.7773V82.9273H0.999023H56.9991H57.1491V82.7773V0.664893ZM55.4247 2.17787L55.4254 81.2022H2.57484V11.2228H11.4698H11.6198V11.0728V2.17787H55.4247ZM3.79424 9.49697L9.89493 3.39629V9.49697H3.79424Z" fill="#EC6608" stroke="#EC6608" stroke-width="0.3" />
                                <path d="M6.23535 58.8986H6.08535V59.0486V60.4736V60.6236H6.23535H51.7621H51.9121V60.4736V59.0486V58.8986H51.7621H6.23535Z" fill="#EC6608" stroke="#EC6608" stroke-width="0.3" />
                                <path d="M6.23535 64.5985H6.08535V64.7485V66.1735V66.3235H6.23535H51.7621H51.9121V66.1735V64.7485V64.5985H51.7621H6.23535Z" fill="#EC6608" stroke="#EC6608" stroke-width="0.3" />
                                <path d="M6.23535 70.2985H6.08535V70.4485V71.8735V72.0235H6.23535H51.7621H51.9121V71.8735V70.4485V70.2985H51.7621H6.23535Z" fill="#EC6608" stroke="#EC6608" stroke-width="0.3" />
                                <path d="M6.23535 75.9984H6.08535V76.1484V77.5734V77.7234H6.23535H51.7621H51.9121V77.5734V76.1484V75.9984H51.7621H6.23535Z" fill="#EC6608" stroke="#EC6608" stroke-width="0.3" />
                                <path d="M29.0001 53.8358C39.1674 53.8358 47.4389 45.5647 47.4389 35.3986C47.4389 25.2326 39.1679 16.9613 29.0001 16.9613C18.8341 16.9613 10.5629 25.2324 10.5629 35.3986C10.5629 45.5645 18.8333 53.8358 29.0001 53.8358ZM29.0001 18.6847C38.2161 18.6847 45.7139 26.1821 45.7139 35.3969C45.7139 44.6116 38.2166 52.1092 29.0001 52.1092C19.7854 52.1092 12.2879 44.6118 12.2879 35.3969C12.2879 26.1823 19.7846 18.6847 29.0001 18.6847Z" fill="#EC6608" stroke="#EC6608" stroke-width="0.3" />
                                <path d="M29.8619 32.4897L29.8619 32.3397H29.7119H28.2869H28.1369V32.4897V43.3199H27.2773H27.1273V43.4699V44.8949V45.0449H27.2773H30.7221H30.8721V44.8949V43.4699V43.3199H30.7221H29.8619L29.8619 32.4897Z" fill="#EC6608" stroke="#EC6608" stroke-width="0.3" />
                                <path d="M29.8595 28.0003L29.8595 28.0004C29.8601 28.4736 29.4736 28.8611 29 28.8611C28.5263 28.8611 28.1404 28.4742 28.1404 28.0015C28.1404 27.5281 28.5265 27.1407 29 27.1407C29.4736 27.1407 29.8595 27.5276 29.8595 28.0003ZM29 30.5861C30.4251 30.5861 31.5845 29.4267 31.5845 28.0016V28.0015C31.5851 26.5764 30.4251 25.4157 29 25.4157C27.5748 25.4157 26.4154 26.5751 26.4154 28.0002C26.4154 29.4259 27.5748 30.5861 29 30.5861Z" fill="#EC6608" stroke="#EC6608" stroke-width="0.3" />
                            </svg>
                            <h3>Plataforma informativa<br> e moderna</h3>
                        </div>
                    </div>
                    <div class="col">
                        <div class="item">
                            <svg width="90" height="91" viewBox="0 0 90 91" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M4.1848 38.6241C4.74474 38.7296 5.30661 38.3625 5.41537 37.7806C8.39441 21.8468 20.9549 9.10872 36.7851 5.82095L34.7867 8.98576C34.476 9.47773 34.6236 10.1289 35.1156 10.4409C35.6076 10.7516 36.2587 10.6053 36.5708 10.1121L39.7149 5.13154C39.8637 4.89527 39.9129 4.60851 39.8514 4.33598C39.7893 4.06346 39.6223 3.82719 39.386 3.67636L34.5143 0.601527C34.0224 0.290813 33.3712 0.437107 33.0592 0.93037C32.7485 1.42234 32.896 2.07353 33.388 2.38554L35.7715 3.88991C19.3898 7.54076 6.44005 20.8193 3.34285 37.3924C3.2341 37.9646 3.61278 38.5155 4.18501 38.6229L4.1848 38.6241Z" fill="#EC6608" />
                                <path d="M37.5477 84.8501C21.9978 81.9423 9.49728 69.9066 5.84659 54.6139L8.55171 56.3222C9.04238 56.6303 9.69617 56.4866 10.0069 55.9934C10.3176 55.5014 10.17 54.8502 9.67804 54.5382L4.69949 51.3941C4.46321 51.2452 4.17646 51.1947 3.90393 51.2575C3.63141 51.3196 3.39513 51.4867 3.2443 51.7229L0.167649 56.5946C-0.141773 57.0866 0.00581829 57.7391 0.497784 58.0498C0.98975 58.3605 1.64095 58.2142 1.95295 57.7209L3.74731 54.8804C7.52112 71.0797 20.7214 83.8506 37.1619 86.9246C37.7219 87.0301 38.2837 86.6631 38.3925 86.0811C38.498 85.5102 38.12 84.9574 37.5477 84.8506V84.8501Z" fill="#EC6608" />
                                <path d="M57.4035 89.8164C57.6844 89.3063 57.4993 88.6648 56.9899 88.3839L53.915 86.688C70.4586 83.1492 83.568 69.7951 86.6917 53.1077C86.7985 52.5354 86.4218 51.9839 85.8495 51.8771C85.2747 51.769 84.7258 52.147 84.619 52.7193C81.6562 68.5514 69.2354 81.2221 53.5525 84.611L55.0316 81.9297C55.3126 81.4196 55.1274 80.7781 54.618 80.4972C54.1118 80.2163 53.4677 80.4027 53.1855 80.9108L50.4026 85.956C50.2673 86.2007 50.2356 86.4887 50.3126 86.7574C50.3897 87.026 50.5716 87.2526 50.8163 87.3885L55.9735 90.2328C56.4751 90.5099 57.1205 90.3299 57.404 89.8179L57.4035 89.8164Z" fill="#EC6608" />
                                <path d="M89.5025 32.9334C89.0106 32.6227 88.3581 32.769 88.0474 33.2623L86.3586 35.9364C82.687 19.5857 69.4209 6.66793 52.8727 3.57405C52.303 3.46983 51.7509 3.84398 51.6421 4.4175C51.5353 4.98973 51.9121 5.54124 52.4856 5.64806C68.2349 8.59214 80.8559 20.9022 84.3209 36.4759L81.4481 34.6621C80.9562 34.3514 80.305 34.4977 79.993 34.991C79.6822 35.483 79.8298 36.1342 80.3218 36.4462L85.3023 39.5903C85.5457 39.7437 85.8364 39.787 86.0979 39.7268C86.3704 39.6647 86.6067 39.4977 86.7575 39.2614L89.8324 34.3909C90.1411 33.8957 89.9948 33.2445 89.5016 32.9325L89.5025 32.9334Z" fill="#EC6608" />
                                <path d="M13.2305 45.4002C13.2305 62.9162 27.4826 77.1693 44.9996 77.1693C62.5166 77.1693 76.7687 62.9172 76.7687 45.4002C76.7687 27.8832 62.5166 13.6311 44.9996 13.6311C27.4826 13.6311 13.2305 27.8832 13.2305 45.4002ZM24.3988 66.6912H65.5987C60.2582 71.8599 53.0006 75.0584 44.9987 75.0584C36.9972 75.059 29.7394 71.8599 24.3988 66.6912ZM36.4028 34.8127C36.4028 30.0729 40.2595 26.2163 44.9992 26.2163C49.739 26.2163 53.5957 30.0729 53.5957 34.8127C53.5957 39.5536 49.739 43.4091 44.9992 43.4091C40.2595 43.4111 36.4028 39.5536 36.4028 34.8127ZM64.5792 64.5816H25.4209C25.9711 54.2588 34.5436 46.0282 45.0001 46.0282C55.4581 46.0282 64.0307 54.2583 64.5792 64.5816ZM45.0001 15.739C61.3541 15.739 74.6596 29.0434 74.6596 45.3985C74.6596 53.1755 71.6269 60.2409 66.7125 65.5361C66.6658 55.2075 59.3698 46.5701 49.6621 44.4357C53.2334 42.699 55.7069 39.0435 55.7069 34.8127C55.7069 28.9098 50.9038 24.1067 45.0009 24.1067C39.0967 24.1067 34.2949 28.9098 34.2949 34.8127C34.2949 39.0435 36.7684 42.699 40.3397 44.4357C30.6311 46.57 23.3357 55.2078 23.2893 65.5361C18.3736 60.2411 15.3408 53.1755 15.3408 45.3969C15.3395 29.0442 28.6452 15.739 44.9987 15.739H45.0001Z" fill="#EC6608" />
                            </svg>
                            <h3>Personalização do seu<br> plano de aprendizado</h3>
                        </div>
                    </div>
                    <div class="col">
                        <div class="item">
                            <svg width="79" height="76" viewBox="0 0 79 76" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M43.0378 43.6062C37.3365 43.6062 31.8694 41.3416 27.838 37.3109C23.8067 33.2795 21.542 27.8117 21.542 22.1111C21.542 16.4098 23.8067 10.942 27.838 6.91064C31.8694 2.87993 37.3365 0.615234 43.0378 0.615234C48.7391 0.615234 54.2062 2.87993 58.2376 6.91064C62.269 10.942 64.5337 16.4098 64.5337 22.1111C64.5286 27.8104 62.2626 33.2751 58.2326 37.3051C54.2019 41.3352 48.7372 43.6019 43.0378 43.6062ZM43.0378 3.72418C38.1585 3.72418 33.4796 5.6625 30.0296 9.11312C26.5797 12.5637 24.642 17.2433 24.6426 22.1226C24.6433 27.0013 26.5829 31.6804 30.0335 35.1295C33.4846 38.5789 38.165 40.5159 43.0437 40.5146C47.9231 40.5127 52.6019 38.5723 56.0506 35.1212C59.4993 31.6695 61.435 26.9891 61.4332 22.1104C61.4256 17.2343 59.4853 12.561 56.0366 9.11426C52.5879 5.66755 47.9134 3.72923 43.038 3.72401L43.0378 3.72418Z" fill="#EC6608" />
                                <path d="M76.9459 49.2606C76.0718 48.2103 74.8605 47.4959 73.5189 47.2376C72.1772 46.98 70.7873 47.1956 69.5862 47.8471L67.8902 45.7859H67.8896C67.1472 44.9157 66.1148 44.3437 64.9829 44.1758C63.8512 44.0085 62.6972 44.256 61.7341 44.8737L60.0648 45.9774L59.0616 44.7827C58.3204 43.9131 57.2892 43.3412 56.1595 43.1739C55.029 43.0059 53.8762 43.2534 52.915 43.8705L41.5875 51.2487L29.0017 46.0684H29.0024C27.0531 45.2732 24.9277 45.0117 22.8444 45.3094C20.761 45.6078 18.794 46.4552 17.1464 47.765L1.09532 60.5327C0.745435 60.7789 0.513233 61.1587 0.452797 61.5823C0.392997 62.0054 0.510051 62.4348 0.777241 62.7688C1.04442 63.1028 1.43758 63.3114 1.86381 63.3458C2.29004 63.3802 2.71181 63.2364 3.02861 62.9495L19.0796 50.1818C20.3004 49.2084 21.7598 48.5793 23.3056 48.3597C24.8515 48.1396 26.4279 48.3375 27.8713 48.9323L50.1241 58.0523C51.0358 58.4613 51.6694 59.3151 51.7967 60.3062C51.9239 61.298 51.5276 62.2841 50.7489 62.9106C49.9702 63.5372 48.9218 63.7141 47.981 63.3782L32.9237 57.5053C32.5363 57.3271 32.0929 57.3163 31.6972 57.476C31.3021 57.6357 30.9898 57.9506 30.8339 58.3475C30.6781 58.7445 30.6927 59.1879 30.874 59.5741C31.0553 59.9596 31.388 60.2535 31.7933 60.3871L46.8048 66.306C47.4995 66.5751 48.2387 66.7144 48.9843 66.7163C50.5219 66.7137 51.9998 66.1208 53.113 65.0597C54.2263 63.9992 54.8898 62.552 54.9668 61.0163L55.1399 60.9253L70.8269 50.683C71.6673 50.1608 72.7188 50.1124 73.6032 50.5558C74.4881 50.9992 75.0791 51.8701 75.1637 52.8562C75.2483 53.8422 74.815 54.8015 74.0186 55.3894L52.769 70.4557C50.0385 72.3999 46.5708 72.994 43.348 72.0696L25.4093 67.0173C22.1088 66.0866 18.561 66.8252 15.9063 68.9963L11.0727 72.9634C10.5765 73.3813 10.3932 74.0639 10.6127 74.674C10.8328 75.2848 11.4092 75.6938 12.0574 75.6995C12.4137 75.7027 12.7598 75.5799 13.0333 75.3528L17.9127 71.4316C19.7818 69.899 22.2818 69.3781 24.6069 70.0358L42.5 75.0793C46.6172 76.241 51.0399 75.4693 54.5204 72.9819L75.8156 57.9156C77.1699 56.9589 78.0625 55.4798 78.2768 53.8359C78.4918 52.192 78.0096 50.533 76.9466 49.2606L76.9459 49.2606ZM54.5384 46.4609C55.2216 46.0271 56.1205 46.1632 56.6448 46.7797L57.4107 47.6919L48.0083 53.8842L45.0622 52.6711L54.5384 46.4609ZM54.1917 57.8336C53.5727 56.7229 52.6134 55.8406 51.4555 55.3163L63.3938 47.4641C64.0757 47.0322 64.9714 47.1639 65.5002 47.7739L66.9417 49.5431L54.1917 57.8336Z" fill="#EC6608" />
                                <path d="M43.2277 15.4533C44.7392 15.5029 46.2406 15.7173 47.7057 16.092C48.5314 16.3184 49.385 15.8324 49.6116 15.0067C49.838 14.1803 49.3527 13.3273 48.5263 13.1008C47.2953 12.7859 46.0421 12.5632 44.778 12.4347V10.3277C44.778 9.47139 44.0839 8.77734 43.2276 8.77734C42.3714 8.77734 41.6773 9.47139 41.6773 10.3277V12.4525C37.5188 13.018 37.0168 15.8541 37.0168 17.1493C37.0168 20.3689 40.3364 21.7093 42.325 22.5483L42.708 22.7035L43.292 22.9408C45.2984 23.7341 46.1737 24.236 46.1737 25.677C46.1737 27.1179 45.2068 27.8202 43.3193 27.9023H42.9904C41.2124 27.7388 39.4674 27.3176 37.8101 26.6528C37.4227 26.4836 36.9825 26.4798 36.5919 26.6433C36.2019 26.8061 35.8946 27.1217 35.7432 27.5167C35.5912 27.9118 35.6071 28.3514 35.7871 28.7344C35.9678 29.1167 36.2967 29.4093 36.6975 29.5436C38.3076 30.1575 39.9763 30.6034 41.6773 30.8751V32.9635C41.6773 33.8198 42.3714 34.5139 43.2276 34.5139C44.0839 34.5139 44.7779 33.8198 44.7779 32.9635V30.8024C47.5962 30.2553 49.2743 28.3856 49.2743 25.6311C49.2743 21.9834 46.2461 20.779 44.4407 20.0589L43.5284 19.6759C42.106 19.0919 40.1447 18.2897 40.1447 17.1497C40.1174 16.6026 40.1174 15.453 43.2276 15.453L43.2277 15.4533Z" fill="#EC6608" />
                            </svg>
                            <h3>Valor acessível à<br> todos os usuários</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</section>

<section id="apps" class="d-none">
    <div class="container">
        <div class="row flex-md-row-reverse">
            <div class="col-12 col-md-6">
                <img src="<?= get_template_directory_uri() ?>/img/img-app.png" alt="" class="apps">
            </div>
            <div class="col-12 col-md-6 my-md-auto">
                <h2>Prospere tendo dívidas. Educação financeira como você nunca viu!</h2>
                <p>Assista a cursos e séries direto do seu celular.</p>
                <div class="links">
                    <a href="http://" target="_blank" rel="noopener noreferrer"><img src="<?= get_template_directory_uri() ?>/img/icons/gplay-dark.svg" alt=""></a>
                    <a href="http://" target="_blank" rel="noopener noreferrer"><img src="<?= get_template_directory_uri() ?>/img/icons/apple-dark.svg" alt=""></a>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="teachers" class="container">
    <div class="row">
        <div class="col-12 title">
            <h2><?= get_field('title_teacher') ?></h2>
            <p><?= get_field('desc_teacher') ?></p>
        </div>
        <div class="col-12 carousel">
            <?php if (have_rows('teachers', $pageHome)) : while (have_rows('teachers', $pageHome)) : the_row(); ?>
                    <div class="teacher">
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <img src="<?= get_sub_field('img')['url'] ?>" alt="<?= get_sub_field('img')['alt'] ?>" class="thumb">
                            </div>
                            <div class="col-12 col-md-6  content">
                                <div class="teacher-content">
                                <h3><?= get_sub_field('name') ?></h3>
                                <a href="<?= get_sub_field('url') ?>"><img src="<?= get_template_directory_uri() ?>/img/icons/linkedin.svg" alt=""></a>
                                <p><?= get_sub_field('desc') ?></p>
                                </div>
                                <div class="slick-arrows"></div>
                            </div>
                        </div>
                    </div>
            <?php endwhile;
            endif; ?>
        </div>
    </div>
</section>

<section id="useApp">
    <div id="use" class="container" style="background-image: <?= !empty(get_field('bg_new')) ? 'url(' . get_field('bg_new') . ')' : '' ?>">
        <div class="row">
            <div class="col-12 col-md-10 mx-auto">
                <div class="row">
                    <div class="col-12 col-md-8">
                        <div class="logo"><img src="<?= get_template_directory_uri() ?>/img/icons/logo.svg" alt="Logo"></div>
                        <h2>Autonomia financeira focada em realizar os seus sonhos.</h2>
                        <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-orange">Assine a partir de R$9,90/mês</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="signFooter">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-4 img">
                <img src="<?= get_template_directory_uri() ?>/img/flat-ipad.png" alt="">
            </div>
            <div class="col-12 col-md-8 content">
                <div class="d-block d-lg-flex">
                    <h2>Assine Anual<br>
                        <span>R$ 99,<span class="cents">80</span></span>
                    </h2>
                    <h2>Assine Mensal<br>
                        <span>R$ 9,<span class="cents">90</span></span>
                    </h2>
                </div>
                <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-black">Assine agora</a>
            </div>
        </div>
    </div>
</section>


<?php get_footer(); ?>