<?php
$streaming_courses = get_streaming_courses();

$streaming_courses_url = 'https://streaming.dflix.com.br/course/';

$posts = get_posts([
    'numberposts' => 4
]);
add_filter('excerpt_length', 'html5wp_custom_post');

$pageFaq = get_page_by_path('ajuda');

get_header(); ?>

<section id="bannerHome" class="light-theme" style="background-image: url(<?= get_template_directory_uri() ?>/img/banner-home.png);">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-9 content">
                <h1><?= get_field('title_banner') ?></h1>
                <p><?= get_field('desc_banner') ?></p>
                <!--span class="tag">Ganhe 2 meses grátis</span-->
                <div class="box-plans">
                    <div>
                        <h2><span>Assinatura Anual</span> <br> R$ 99,80</h2>
                    </div>
                    <div>
                        <h2><span>Assinatura Mensal</span> <br> R$ 9,90</h2>
                    </div>
                </div>
                <a href="<?= get_field('link')['url'] ?>" target="<?= get_field('link')['target'] ?>" class="btn-orange"><?= get_field('link')['title'] ?></a>

                
            </div>
        </div>
    </div>
</section>

<section id="infos" class="d-none">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-4">
                <h2><?= get_field('title_sub') ?></h2>
            </div>
            <div class="col-12 col-md-8 content">
                <h3><span><?= get_field('descs_sub')['dest_1'] ?></span> <?= get_field('descs_sub')['text_1'] ?></h3>
                <h3><span><?= get_field('descs_sub')['dest_2'] ?></span> <?= get_field('descs_sub')['text_2'] ?></h3>
                <h3><span><?= get_field('descs_sub')['dest_3'] ?></span> <?= get_field('descs_sub')['text_3'] ?></h3>
            </div>
        </div>
    </div>
</section>

<section id="whatLearn">
    <div class="container-fluid">
        <div id="slider-courses" class="row">
        <?php foreach($streaming_courses as $course) { ?>
            <div class="col-12 col-sm-6 col-md-3 col-lg-2 col-xl-2">
                <a href="https://streaming.dflix.com.br/">
                    <div class="card-course">
                        <img src="<?= $course['imageUrl'] ?>" alt="" class="img-fluid d-block mx-auto">
                    </div>
                </a>
            </div>
        <?php } ?>
        </div>
    </div>
    <div class="container">
        <div class="row flex-md-row-reverse">
            <div class="col-12 col-xl img">
                <h2>O que você vai aprender na DFLIX</h2>
                <div class="img-content">
                    <img src="<?= get_template_directory_uri() ?>/img/content1-home.png" alt="">
                </div>
            </div>
            <div class="col-12 col-xl-4 content">
                <h2>O que você vai aprender na DFLIX</h2>
                <h3>Aprenda sobre Educação Comportamental Financeira da maneira que você quiser: Assista a cursos ou séries</h3>
                <div class="row item">
                    <div class="col-3 icon">
                        <img src="<?= get_template_directory_uri() ?>/img/icons/heroicons.svg" alt="">
                    </div>
                    <div class="col-9">
                        <p><span>Curso:</span> Aulas de diversos assuntos relacionados à Educação Comportamental Financeira. Você aprende vendo especialistas da Educação Financeira compartilhando suas experiências.</p>
                    </div>
                </div>
                <hr>
                <div class="row item">
                    <div class="col-3 icon">
                        <img src="<?= get_template_directory_uri() ?>/img/icons/clarity-video.svg" alt="">
                    </div>
                    <div class="col-9">
                        <p><span>Séries:</span> Acompanhe Séries originais feitas para consolidar e vivenciar seu aprendizado, Em pouco tempo você dominará a Educação Comportamental Financeira.</p>
                    </div>
                </div>
                <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-orange">Assine agora</a>
            </div>
        </div>
    </div>
</section>

<section id="forYou">
    <div class="item-foryou" style="background-image: url(<?= get_template_directory_uri() ?>/img/bg-foryou-mob.png);">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6"></div>
                <div class="col-12 col-lg-6">
                    <div class="item-foryou-content d-flex">
                        <div class="my-auto">
                            <h3>Para Você</h3>
                            <h2>Pagar à vista ou parcelar? Cozinhar ou ir jantar fora? Comprar hoje ou no próximo mês?</h2>
                            <p>Essas e outras preocupações do comportamento financeiro fazem parte do dia-a-dia. Assine DFLIX, aprenda tudo sobre a Educação do comportamento financeiro.</p>
                            <a href="<?= home_url() ?>/para-voce" class="btn-orange">Assine agora</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="item-foryou" style="background-image: url(<?= get_template_directory_uri() ?>/img/bg-foryourbusinnes.png);">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6"></div>
                <div class="col-12 col-lg-6">
                <div class="item-foryou-content d-flex">
                    <div class="my-auto">
                        <h3>Para negócios</h3>
                        <h2>A educação financeira é o caminho para o sucesso da sua empresa</h2>
                        <p>Benefícios reais para o seu time e o seu negócio subir de nível </p>
                        <a href="<?= home_url() ?>/para-seu-negocio" class="btn-orange">Assine agora</a>
                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="apps" class="d-none">
    <div class="container">
        <div class="row flex-md-row-reverse">
            <div class="col-12 col-md-6">
                <img src="<?= get_template_directory_uri() ?>/img/img-app.png" alt="" class="apps">
            </div>
            <div class="col-12 col-md-6 my-md-auto">
                <h2>Prospere tendo dívidas. Educação financeira como você nunca viu!</h2>
                <p>Assista a cursos e séries direto do seu celular.</p>
                <div class="links">
                    <a href="http://" target="_blank" rel="noopener noreferrer"><img src="<?= get_template_directory_uri() ?>/img/icons/gplay-dark.svg" alt=""></a>
                    <a href="http://" target="_blank" rel="noopener noreferrer"><img src="<?= get_template_directory_uri() ?>/img/icons/apple-dark.svg" alt=""></a>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="teachers" class="container">
    <div class="row">
        <div class="col-12 title">
            <h2><?= get_field('title_teacher') ?></h2>
            <p><?= get_field('desc_teacher') ?></p>
        </div>
        <div class="col-12 carousel">
            <?php if (have_rows('teachers')) : while (have_rows('teachers')) : the_row(); ?>
                    <div class="teacher">
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <img src="<?= get_sub_field('img')['url'] ?>" alt="<?= get_sub_field('img')['alt'] ?>" class="thumb">
                            </div>
                           <!--  <div class="col-12 col-md-6 my-md-auto content"> -->
                            <div class="col-12 col-md-6 content">
                            <div class="teacher-content"> 
                            <h3><?= get_sub_field('name') ?></h3>
                                <a href="<?= get_sub_field('url') ?>"><img src="<?= get_template_directory_uri() ?>/img/icons/linkedin.svg" alt=""></a>
                                <p><?= get_sub_field('desc') ?></p>
                                </div>
                                <div class="slick-arrows"></div>
                            </div>
                        </div>
                    </div>
            <?php endwhile;
            endif; ?>
        </div>
    </div>
</section>

<section id="about">
    <div class="container">
        <div class="row">
            <div class="col-12 title">
                <h2>O que estão dizendo sobre a DFLIX</h2>
            </div>
            <div class="col-12 carousel-about">
                <?php if (have_rows('comment')) : while (have_rows('comment')) : the_row(); ?>
                        <div class="colab">
                            <img src="<?= get_sub_field('icon') ?>" alt="" class="icon">
                            <h3><?= get_sub_field('name') ?></h3>
                            <h4><?= get_sub_field('role') ?></h4>
                            <svg width="32" class="quote" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.823 14.7787C10.1903 14.7809 9.56884 14.9458 9.01836 15.2577C9.79338 13.2516 11.0788 11.4827 12.7474 10.126C12.8429 10.0473 12.9219 9.95069 12.98 9.84151C13.0382 9.73234 13.0742 9.61279 13.0861 9.48969C13.098 9.36659 13.0856 9.24234 13.0495 9.12405C13.0134 9.00576 12.9543 8.89574 12.8757 8.80027C12.7971 8.7048 12.7004 8.62575 12.5913 8.56763C12.4821 8.50952 12.3625 8.47348 12.2394 8.46156C12.1163 8.44965 11.9921 8.4621 11.8738 8.4982C11.7555 8.53431 11.6455 8.59335 11.55 8.67198C8.12886 11.4517 6.60645 15.3005 6.60645 17.6867C6.61234 18.5304 6.86378 19.3542 7.33005 20.0574C7.79633 20.7606 8.45727 21.3129 9.23218 21.6467C9.73369 21.8896 10.2829 22.0182 10.8401 22.023C11.3306 22.0469 11.8208 21.9708 12.281 21.7996C12.7412 21.6283 13.1619 21.3653 13.5174 21.0267C13.873 20.688 14.1561 20.2806 14.3495 19.8292C14.5429 19.3779 14.6426 18.8919 14.6426 18.4009C14.6426 17.9098 14.5429 17.4239 14.3495 16.9725C14.1561 16.5212 13.873 16.1138 13.5174 15.7751C13.1619 15.4364 12.7412 15.1735 12.281 15.0022C11.8208 14.8309 11.3306 14.7549 10.8401 14.7787H10.823Z" fill="#EC6608" />
                                <path d="M20.3514 14.7788C19.7186 14.7802 19.0969 14.9452 18.5467 15.2578C19.3215 13.2538 20.6035 11.4854 22.2672 10.126C22.3714 10.051 22.4591 9.95538 22.5249 9.84517C22.5907 9.73496 22.6332 9.61244 22.6499 9.48516C22.6666 9.35788 22.6571 9.22854 22.6219 9.10508C22.5868 8.98162 22.5267 8.86666 22.4455 8.76729C22.3642 8.66791 22.2635 8.58621 22.1495 8.52722C22.0354 8.46823 21.9106 8.4332 21.7825 8.42427C21.6544 8.41535 21.5259 8.43273 21.4048 8.47534C21.2837 8.51795 21.1726 8.58489 21.0784 8.67204C17.6572 11.4517 16.1348 15.3005 16.1348 17.6868C16.1389 18.521 16.383 19.3363 16.838 20.0355C17.293 20.7347 17.9396 21.2881 18.7007 21.6297C19.2149 21.8797 19.7796 22.0085 20.3514 22.006C20.8419 22.0298 21.3321 21.9538 21.7923 21.7825C22.2525 21.6113 22.6731 21.3483 23.0287 21.0096C23.3843 20.6709 23.6673 20.2635 23.8607 19.8122C24.0542 19.3608 24.1539 18.8749 24.1539 18.3838C24.1539 17.8928 24.0542 17.4068 23.8607 16.9555C23.6673 16.5041 23.3843 16.0967 23.0287 15.7581C22.6731 15.4194 22.2525 15.1564 21.7923 14.9851C21.3321 14.8139 20.8419 14.7378 20.3514 14.7617V14.7788Z" fill="#EC6608" />
                            </svg>
                            <p><?= get_sub_field('comment') ?></p>
                        </div>
                <?php endwhile;
                endif; ?>
            </div>
        </div>
    </div>
</section>

<section id="use" class="container" style="background-image: <?= !empty(get_field('bg_anuncio')) ? 'url(' . get_field('bg_anuncio') . ')' : '' ?>">
    <div class="row">
        <div class="col-12 col-md-10 mx-auto">
            <div class="row">
                <div class="col-12 col-md-8">
                    <div class="logo"><img src="<?= get_template_directory_uri() ?>/img/icons/logo.svg" alt="Logo"></div>
                    <h2>Utilize a dívida ao seu favor e aprenda como você e sua família podem prosperar.</h2>

                    <div class="box-plans">
                        <div>
                            <p class="mb-0">
                                <span>Assinatura Anual</span><br>
                                R$ 99,80
                            </p>
                        </div>
                        <div>
                            <p class="mb-0">
                                <span>Assinatura Mensal</span><br>
                                R$ 9,90
                            </p>
                        </div>
                    </div>

                    <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-orange">Assine agora</a>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="faq">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-3 title">
                <h2>Dúvidas <br> Frequentes</h2>
                <p>Tudo o que você precisa saber para entrar para o mundo da Educação Financeira.</p>
                <a href="<?= home_url() ?>/ajuda" class="btn-orange d-md-flex d-none">Saiba mais</a>
            </div>
            <div class="col-12 col-md-9">
                <?php if (!empty(get_field('questions', $pageFaq))) :
                    $iQuest = 0;
                    while (have_rows('questions', $pageFaq)) : the_row() ?>
                        <div class="item-faq">
                            <button type="button" data-bs-toggle="collapse" data-bs-target="#collapseFaq<?= $iQuest ?>" aria-expanded="false" aria-controls="collapseFaq<?= $iQuest ?>"><?= get_sub_field('quest') ?> <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.5 2.5V7.5H2.5V8.5H7.5V13.5H8.5V8.5H13.5V7.5H8.5V2.5H7.5Z" fill="#212121" />
                                </svg></button>
                            <div class="content collapse" id="collapseFaq<?= $iQuest ?>" data-bs-parent="#faq">
                                <p><?= get_sub_field('answer') ?></p>
                            </div>
                        </div>
                <?php $iQuest++;
                    endwhile;
                endif; ?>
                <a href="<?= home_url() ?>/ajuda" class="btn-orange d-flex d-md-none">Saiba mais</a>
            </div>
        </div>
    </div>
</section>

<?php if (count($posts) > 1) { ?>
<section id="blogSection">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h2>Tudo sobre o universo da Educação Comportamental Financeira com Conteúdos de qualidade feitos exclusivamente para você. </h2>
            </div>
            <div class="col-12 col-md-6">
                <div class="first-post">
                    <img src="<?= get_the_post_thumbnail_url($posts[0]) ?>" alt="">
                    <p class="category"><?= get_the_category($posts[0]->ID)[0]->name ?></p>
                    <h3><?= get_the_title($posts[0]) ?></h3>
                    <p class="date"><?= get_the_date('d \d\e F Y', $posts[0]); ?></p>
                    <p class="excerpt"><?= get_the_excerpt($posts[0]) ?></p>
                    <a href="<?= get_permalink($posts[0]) ?>" class="btn-orange">Ler agora</a>
                </div>
            </div>

            <div class="d-md-block d-none col-6">
                <?php foreach ($posts as $key => $post) :
                    if ($key != 0) : ?>
                        <div class="post">
                            <div class="thumb">
                                <img src="<?= get_the_post_thumbnail_url($post) ?>" alt="">
                            </div>
                            <div class="content">
                                <h3><?= get_the_title($post) ?></h3>
                                <a href="<?= get_permalink($post) ?>">Leia Mais <img src="<?= get_template_directory_uri() ?>/img/icons/arrow-r-white.svg" alt=""></a>
                            </div>
                        </div>
                    <?php else : ?>
                <?php endif;
                endforeach; ?>
                <a href="<?= home_url() ?>/blog" class="btn-orange">Ver tudo</a>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<section id="signFooter">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-4 img">
                <img src="<?= get_template_directory_uri() ?>/img/flat-ipad.png" alt="">
            </div>
            <div class="col-12 col-md-8 content">
                <div class="d-block d-lg-flex">
                    <h2>Assine Anual<br>
                        <span>R$ 99,<span class="cents">80</span></span>
                    </h2>
                    <h2>Assine Mensal<br>
                        <span>R$ 9,<span class="cents">90</span></span>
                    </h2>
                </div>
                <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-black">Assine agora</a>
            </div>
        </div>
    </div>
</section>



<?php get_footer(); ?>