<?php
$postsReadMore = get_posts([
	'numberposts' => 2
]);
get_header(); ?>
<section id="bannerSingle" class="banner-container">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="bread-crumb">
					<a href="<?= home_url() ?>">Home</a>
					>
					<a href="<?= get_permalink(24) ?>">BLOG</a>
					>
					<span><?= get_the_title() ?></span>
				</div>
			</div>
			<div class="col-11 mx-auto mx-md-0 col-lg-8 content">
				<h1><?= get_the_title() ?></h1>
			</div>
		</div>
	</div>
	<div class="thumb">
		<img src="<?= get_the_post_thumbnail_url() ?>" alt="">
	</div>
</section>

<section id="content" class="container">
	<div class="row">
		<div class="col-12 col-lg-8">
			<div class="content-post">
				<?= get_the_content() ?>
			</div>

			<div class="footer-single footer-posts">
				<h3>Leia Mais</h3>
				<div class="posts">
					<?php foreach ($postsReadMore as $p) : if ($post->ID != $p->ID) : ?>
						<div class="post">
							<div class="thumb">
								<img src="<?= get_the_post_thumbnail_url($p) ?>" alt="">
							</div>
							<div class="content">
								<h4><?= get_the_title($p) ?></h4>
								<a href="<?= get_permalink($p) ?>">Leia Mais <svg width="54" height="16" viewBox="0 0 54 16" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M52.7159 8.70711C53.1064 8.31658 53.1064 7.68342 52.7159 7.29289L46.3519 0.928932C45.9614 0.538408 45.3282 0.538408 44.9377 0.928932C44.5472 1.31946 44.5472 1.95262 44.9377 2.34315L50.5946 8L44.9377 13.6569C44.5472 14.0474 44.5472 14.6805 44.9377 15.0711C45.3282 15.4616 45.9614 15.4616 46.3519 15.0711L52.7159 8.70711ZM0.00878906 9H52.0088V7H0.00878906V9Z" fill="#212121" />
									</svg></a>
							</div>
						</div>
					<?php endif;
				endforeach; ?>
				</div>
			</div>
			<div class="footer-single footer-nav">
				<div class="next-post-link">
					<?= next_post_link('%link', 'Próximo post <svg width="54" height="16" viewBox="0 0 54 16" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M52.7159 8.70711C53.1064 8.31658 53.1064 7.68342 52.7159 7.29289L46.3519 0.928932C45.9614 0.538408 45.3282 0.538408 44.9377 0.928932C44.5472 1.31946 44.5472 1.95262 44.9377 2.34315L50.5946 8L44.9377 13.6569C44.5472 14.0474 44.5472 14.6805 44.9377 15.0711C45.3282 15.4616 45.9614 15.4616 46.3519 15.0711L52.7159 8.70711ZM0.00878906 9H52.0088V7H0.00878906V9Z" fill="#212121" />
						</svg>') ?>
				</div>
				<div class="previous-post-link">
					<?= previous_post_link('%link', '<svg width="54" height="16" viewBox="0 0 54 16" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M52.7159 8.70711C53.1064 8.31658 53.1064 7.68342 52.7159 7.29289L46.3519 0.928932C45.9614 0.538408 45.3282 0.538408 44.9377 0.928932C44.5472 1.31946 44.5472 1.95262 44.9377 2.34315L50.5946 8L44.9377 13.6569C44.5472 14.0474 44.5472 14.6805 44.9377 15.0711C45.3282 15.4616 45.9614 15.4616 46.3519 15.0711L52.7159 8.70711ZM0.00878906 9H52.0088V7H0.00878906V9Z" fill="#212121" />
						</svg> Post anteiror') ?>
				</div>
			</div>
			<div class="footer-single footer-social">
				<h3>COMPARTILHAR</h3>
				<div class="content">
					<a href="https://www.facebook.com/sharer/sharer.php?u=<?= get_permalink() ?>" target="_blank">
						<img src="<?= get_template_directory_uri() ?>/img/icons/facebook-social.svg" alt="facebook">
					</a>
					<a href="https://www.linkedin.com/shareArticle?mini=true&url=<?= get_permalink() ?>&title=<?= get_the_title() ?>" target="_blank">
						<img src="<?= get_template_directory_uri() ?>/img/icons/linkedin-social.svg" alt="linkedin">
					</a>
					<a href="https://api.whatsapp.com/send?text=<?= get_permalink() ?>" target="_blank">
						<img src="<?= get_template_directory_uri() ?>/img/icone_whatsapp.png" alt="whatsapp">
					</a>
					<a href="mailto:?subject=<?= get_the_title() ?>&body=<?= get_permalink() ?>" target="_blank">
						<img src="<?= get_template_directory_uri() ?>/img/icons/mail-to.svg" alt="email">
					</a>
				</div>
			</div>
			<div class="footer-single footer-form">
				<?= do_shortcode('[contact-form-7 id="201" title="Post" product-origin="'.get_the_title().'"]') ?>
			</div>
		</div>
		<div class="col-1"></div>
		<div class="col-12 col-lg-3 d-none d-lg-block">
			<?php get_sidebar(); ?>
		</div>
	</div>
</section>

<section id="black"></section>

<section id="signFooter">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-4 img">
                <img src="<?= get_template_directory_uri() ?>/img/flat-ipad.png" alt="">
            </div>
            <div class="col-12 col-md-8 content">
                <div class="d-block d-lg-flex">
                    <h2>Assine Anual<br>
                        <span>R$ 99,<span class="cents">80</span></span>
                    </h2>
                    <h2>Assine Mensal<br>
                        <span>R$ 9,<span class="cents">90</span></span>
                    </h2>
                </div>
                <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-black">Assine agora</a>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>