<?php

add_filter('excerpt_length', 'html5wp_custom_post');
get_header();
?>

<section id="bannerBlog" class="banner-container">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="bread-crumb">
                    <a href="<?= home_url() ?>">Home</a>
                    >
                    <span><?= get_the_title() ?></span>
                </div>
            </div>
            <div class="col-12 content">
                <h1>Pesquisa</h1>
            </div>
        </div>
    </div>
</section>

<section id="blog">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-8 px-lg-0 blog">
                <div class="row posts">
                    <?php if (have_posts()) : foreach ($posts as $key => $post) : ?>
                        <div class="post col-12 <?= $key != 0 ? 'col-lg-6' : '' ?>">
                            <div class="card-blog <?= $key == 0 ? 'first-post' : '' ?>">
                                <div class="thumb">
                                    <img src="<?= get_the_post_thumbnail_url($post) ?>" alt="">
                                </div>
                                <p class="category"><?= get_the_category($post->ID)[0]->name ?></p>
                                <h2><?= get_the_title($post) ?></h2>
                                <p class="date"><?= get_the_date('d \d\e F Y', $post); ?></p>
                                <p class="excerpt"><?= get_the_excerpt($post) ?></p>
                                <a href="<?= get_permalink($post) ?>" class="btn-orange">Leia Mais</a>
                            </div>
                        </div>
                    <?php endforeach;
                        else:
                    ?>
                    <h2 class="title-not-post">Nenhum resultado encontrado.</h2>
                    <h3 class="text-center mt-2">Tente modificar sua busca.</h3>
                    <?php endif; ?>
                </div>
                <div class="row">
                    <div class="col-12 load-more">
                        <!-- <a href="#" class="btn-orange more-posts">Outras publicações</a> -->
                    </div>
                </div>
            </div>
            <div class="col-lg-1 d-none d-xl-block"></div>
            <div class="col-12 col-lg-4 col-xl-3">
                <?= get_sidebar() ?>
            </div>
        </div>
    </div>
</section>

<section id="signFooter">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-4 img">
                <img src="<?= get_template_directory_uri() ?>/img/flat-ipad.png" alt="">
            </div>
            <div class="col-12 col-md-8 content">
                <div class="d-block d-lg-flex">
                    <h2>Assine Anual<br>
                        <span>R$ 99,<span class="cents">80</span></span>
                    </h2>
                    <h2>Assine Mensal<br>
                        <span>R$ 9,<span class="cents">90</span></span>
                    </h2>
                </div>
                <a href="https://cursos.dflix.com.br/" target="_blank" class="btn-black">Assine agora</a>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>