<?php
$postsSide = get_posts([
	'numberposts' => 3
]);
?>
<!-- sidebar -->
<aside class="sidebar" role="complementary">

	<?php get_template_part('searchform'); ?>

	<div class="sidebar-widget">
		<?php if (!function_exists('dynamic_sidebar') || !dynamic_sidebar('widget-area-1')) ?>
		<div class="widget_block widget-posts">
			<h3>Últimas notícias</h3>
			<?php foreach ($postsSide as $p) : if ($post->ID != $p->ID) :?>
				<div class="post">
					<div class="thumb">
						<img src="<?= get_the_post_thumbnail_url($p) ?>" alt="">
					</div>
					<div class="content">
						<h4><?= get_the_title($p) ?></h4>
						<a href="<?= get_permalink($p) ?>">Leia Mais <svg width="54" height="16" viewBox="0 0 54 16" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M52.7159 8.70711C53.1064 8.31658 53.1064 7.68342 52.7159 7.29289L46.3519 0.928932C45.9614 0.538408 45.3282 0.538408 44.9377 0.928932C44.5472 1.31946 44.5472 1.95262 44.9377 2.34315L50.5946 8L44.9377 13.6569C44.5472 14.0474 44.5472 14.6805 44.9377 15.0711C45.3282 15.4616 45.9614 15.4616 46.3519 15.0711L52.7159 8.70711ZM0.00878906 9H52.0088V7H0.00878906V9Z" fill="#212121" />
							</svg></a>
					</div>
				</div>
			<?php 
			endif;
		endforeach; ?>
		</div>
		<div class="widget_block widget-social d-none">
			<h3>Nossas redes</h3>
			<div class="content">
				<a href="https://www.facebook.com/dflixbrasil" target="_blank">
					<img src="<?= get_template_directory_uri() ?>/img/icons/facebook-social.svg" alt="facebook">
				</a>
				<a href="" target="_blank">
					<img src="<?= get_template_directory_uri() ?>/img/icons/linkedin-social.svg" alt="linkedin">
				</a>
				<a href="https://www.instagram.com/dflix.oficial/" target="_blank">
					<img src="<?= get_template_directory_uri() ?>/img/icons/instagram-social.svg" alt="instagram">
				</a>
				<a href="" target="_blank">
					<img src="<?= get_template_directory_uri() ?>/img/icons/mail-to.svg" alt="email">
				</a>
			</div>
		</div>
	</div>

	<div class="sidebar-widget">
		<?php if (!function_exists('dynamic_sidebar') || !dynamic_sidebar('widget-area-2')) ?>
	</div>

</aside>
<!-- /sidebar -->